// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-plugins.
*
* nymea-plugins is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-plugins is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-plugins. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef INTEGRATIONPLUGINEQ3_H
#define INTEGRATIONPLUGINEQ3_H

#include <integrations/integrationplugin.h>
#include <plugintimer.h>

#include <QHostAddress>

#include "eqivabluetooth.h"

class MaxCube;
class QNetworkReply;

class IntegrationPluginEQ3: public IntegrationPlugin
{
    Q_OBJECT

    Q_PLUGIN_METADATA(IID "io.nymea.IntegrationPlugin" FILE "integrationplugineq-3.json")
    Q_INTERFACES(IntegrationPlugin)

public:
    explicit IntegrationPluginEQ3();
    ~IntegrationPluginEQ3();

    void init() override;
    void discoverThings(ThingDiscoveryInfo *info) override;

    void startPairing(ThingPairingInfo *info) override;
    void confirmPairing(ThingPairingInfo *info, const QString &user, const QString &secret) override;

    void setupThing(ThingSetupInfo *info) override;
    void thingRemoved(Thing *thing) override;

    void executeAction(ThingActionInfo *info) override;

private:
    QString modeToString(EqivaBluetooth::Mode mode);
    EqivaBluetooth::Mode stringToMode(const QString &string);

    PluginTimer *m_pluginTimer = nullptr;
    QList<Param> m_config;
    QHash<MaxCube *, Thing *> m_cubes;

    QHash<Thing *, EqivaBluetooth *> m_eqivaDevices;

private slots:
    void onPluginTimer();
    void cubeConnectionStatusChanged(const bool &connected);

    void wallThermostatFound();
    void radiatorThermostatFound();

    void updateCubeConfig();
    void wallThermostatDataUpdated();
    void radiatorThermostatDataUpdated();

};

#endif // INTEGRATIONPLUGINEQ3_H
