// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-plugins.
*
* nymea-plugins is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-plugins is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-plugins. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef TVEVENTHANDLER_H
#define TVEVENTHANDLER_H

#include <QTcpServer>
#include <QTcpSocket>

class TvEventHandler : public QTcpServer
{
    Q_OBJECT
public:
    explicit TvEventHandler(const QHostAddress &host, const int &port = 8080, QObject *parent = 0);

protected:
    void incomingConnection(qintptr socket) override;

private:
    QHostAddress m_host;
    int m_port;
    bool m_expectingData;

signals:
    void eventOccured(const QByteArray &path);

private slots:
    void readClient();
    void onDisconnected();

};

#endif // TVEVENTHANDLER_H
