# Copyright 2013 - 2021, nymea GmbH
# Contact: contact@nymea.io
#
# This file is part of nymea.
# This project including source code and documentation is protected by
# copyright law, and remains the property of nymea GmbH. All rights, including
# reproduction, publication, editing and translation, are reserved. The use of
# this project is subject to the terms of a license agreement to be concluded
# with nymea GmbH in accordance with the terms of use of nymea GmbH, available
# under https://nymea.io/license
#
# GNU Lesser General Public License Usage
# Alternatively, this project may be redistributed and/or modified under the
# terms of the GNU Lesser General Public License as published by the Free
# Software Foundation; version 3. This project is distributed in the hope that
# it will be useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this project. If not, see <https://www.gnu.org/licenses/>.
#
# For any further details and any questions please contact us under
# contact@nymea.io or see our FAQ/Licensing Information on
# https://nymea.io/license/faq

# This project include file is meant to be used by nymea modbus integration plugins.
# For external plugins you can generate connection by including this project like following:

#   # Generate modbus connection
#   MODBUS_CONNECTIONS += modbus-registers.json
#   MODBUS_TOOLS_CONFIG += VERBOSE
#   include($$[QT_INSTALL_PREFIX]/include/nymea-modbus/modbus-tool.pri)

# On each qmake run the classes will be generated in the build directory.

GENERATE_MODBUS_CONNECTION_BINARY=$${PWD}/tools/generate-connection.py

for(registerDefinition, MODBUS_CONNECTIONS) {
    contains(MODBUS_TOOLS_CONFIG, VERBOSE) {
        message("Generating modbus connection class for $${registerDefinition} (verbose)")
        system(python3 $${GENERATE_MODBUS_CONNECTION_BINARY} -j $${_PRO_FILE_PWD_}/$${registerDefinition} -o $${OUT_PWD}/autogenerated -v)
    } else {
        message("Generating class for $${registerDefinition}")
        system(python3 $${GENERATE_MODBUS_CONNECTION_BINARY} -j $${_PRO_FILE_PWD_}/$${registerDefinition} -o $${OUT_PWD}/autogenerated)
    }
}

# Add all generated pri files to the project
MODBUS_CONNECTIONS_INCLUDES = $$files($${OUT_PWD}/autogenerated/*.pri)
for(MODBUS_CONNECTION, MODBUS_CONNECTIONS_INCLUDES) {
    message("Adding generated connection to project $${MODBUS_CONNECTION}")
    include($${MODBUS_CONNECTION})
    INCLUDEPATH += $${OUT_PWD}/autogenerated
}

greaterThan(QT_MAJOR_VERSION, 5) {
    message("Building using Qt6 support")
    CONFIG *= c++17
    QMAKE_LFLAGS *= -std=c++17
    QMAKE_CXXFLAGS *= -std=c++17
} else {
    message("Building using Qt5 support")
    CONFIG *= c++11
    QMAKE_LFLAGS *= -std=c++11
    QMAKE_CXXFLAGS *= -std=c++11
    DEFINES += QT_DISABLE_DEPRECATED_UP_TO=0x050F00
}
