TEMPLATE = subdirs
SUBDIRS = common

PLUGIN_DIR = plugins

message("Usage: qmake [srcdir]")

PLUGIN_DIRS = $$files($$PLUGIN_DIR/*)
for (entry, PLUGIN_DIRS): PLUGINS += $$section(entry, /, 1, 1)

message("Building plugins:")
for(plugin, PLUGINS) {
    exists($${PLUGIN_DIR}/$${plugin}) {
        SUBDIRS*= $${plugin}
        $${plugin}.subdir = $${PLUGIN_DIR}/$${plugin}
        $${plugin}.depends += common
        message("- $${plugin}")
    } else {
        error("Invalid plugin \"$${plugin}\".")
    }
}

plugininfo.depends = FORCE
for (entry, PLUGINS):plugininfo.commands += test -d $${PLUGIN_DIR}/$${entry} || mkdir -p $${PLUGIN_DIR}/$${entry}; cd $${PLUGIN_DIR}/$${entry} && qmake -o Makefile $$PWD/$${PLUGIN_DIR}/$${entry}/$${entry}.pro && cd ../..;
for (entry, PLUGINS):plugininfo.commands += make -C $${PLUGIN_DIR}/$${entry} plugininfo.h;
QMAKE_EXTRA_TARGETS += plugininfo

lupdate.depends = FORCE plugininfo
for (entry, PLUGINS):lupdate.commands += make -C $${PLUGIN_DIR}/$${entry} lupdate;
QMAKE_EXTRA_TARGETS += lupdate

lrelease.depends = FORCE
for (entry, PLUGINS):lrelease.commands += lrelease $$files($$PWD/$${PLUGIN_DIR}/$${entry}/translations/*.ts, true);
for (entry, PLUGINS):lrelease.commands += rsync -a $$PWD/$${PLUGIN_DIR}/$${entry}/translations/*.qm $$OUT_PWD/$${PLUGIN_DIR}/$${entry}/translations/;
QMAKE_EXTRA_TARGETS += lrelease

message("Configuration done."))
