/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "citation.h"

Citation::Citation(NetworkAccessManager *nam, const QHash<QString, QUuid> idMap, QObject *parent):
    StreamUnlimitedDevice(nam, idMap, "/ui", parent)
{

    connect(this, &StreamUnlimitedDevice::browseResults, this, [this](int commandId, bool success, const BrowserItems &items){
        if (m_playFirstBrowseResult != commandId) {
            return;
        }
        m_playFirstBrowseResult = -1; // Reset it, now that we're handling it
        if (!success || items.isEmpty()) {
            qCWarning(dcStreamUnlimited()) << "Can't play first browse result. Now items returned.";
            return;
        }
        playBrowserItem(items.first().id());
    });

}

