/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "integrationpluginstreamsdk.h"
#include "streamsdkdevboard.h"
#include "plugininfo.h"

#include <QDebug>
#include <QJsonDocument>

QHash<QString, QUuid> idMap = {
    {"thingClassId", streamSDKdevBoardThingClassId},
    {"idParamTypeId", streamSDKdevBoardThingIdParamTypeId},

    {"connectedStateTypeId", streamSDKdevBoardConnectedStateTypeId},
    {"playbackStatusStateTypeId", streamSDKdevBoardPlaybackStatusStateTypeId},
    {"playDurationStateTypeId", streamSDKdevBoardPlayDurationStateTypeId},
    {"playTimeStateTypeId", streamSDKdevBoardPlayTimeStateTypeId},
    {"volumeStateTypeId", streamSDKdevBoardVolumeStateTypeId},
    {"muteStateTypeId", streamSDKdevBoardMuteStateTypeId},
    {"titleStateTypeId", streamSDKdevBoardTitleStateTypeId},
    {"artistStateTypeId", streamSDKdevBoardArtistStateTypeId},
    {"collectionStateTypeId", streamSDKdevBoardCollectionStateTypeId},
    {"artworkStateTypeId", streamSDKdevBoardArtworkStateTypeId},
    {"shuffleStateTypeId", streamSDKdevBoardShuffleStateTypeId},
    {"repeatStateTypeId", streamSDKdevBoardRepeatStateTypeId},
    {"powerStateTypeId", streamSDKdevBoardPowerStateTypeId},

    {"playActionTypeId", streamSDKdevBoardPlayActionTypeId},
    {"pauseActionTypeId", streamSDKdevBoardPauseActionTypeId},
    {"stopActionTypeId", streamSDKdevBoardStopActionTypeId},
    {"skipNextActionTypeId", streamSDKdevBoardSkipNextActionTypeId},
    {"skipBackActionTypeId", streamSDKdevBoardSkipBackActionTypeId},
    {"increaseVolumeActionTypeId", streamSDKdevBoardIncreaseVolumeActionTypeId},
    {"increaseVolumeActionStepParamTypeId", streamSDKdevBoardIncreaseVolumeActionStepParamTypeId},
    {"decreaseVolumeActionTypeId", streamSDKdevBoardDecreaseVolumeActionTypeId},
    {"decreaseVolumeActionStepParamTypeId", streamSDKdevBoardDecreaseVolumeActionStepParamTypeId},

    {"addToPlayQueueBrowserItemActionTypeId", streamSDKdevBoardAddToPlayQueueBrowserItemActionTypeId},
    {"clearPlaylistBrowserItemActionTypeId", streamSDKdevBoardClearPlaylistBrowserItemActionTypeId},
};

IntegrationPluginStreamSDK::IntegrationPluginStreamSDK(): IntegrationPluginStreamUnlimited(idMap)
{
}

void IntegrationPluginStreamSDK::setupThing(ThingSetupInfo *info)
{
    IntegrationPluginStreamUnlimited::setupThing(info);

    Thing *thing = info->thing();
    StreamSDKDevBoard* device = dynamic_cast<StreamSDKDevBoard*>(m_devices.value(info->thing()));

    connect(device, &StreamSDKDevBoard::inputSourceChanged, thing, [=](const QString &inputSource){
        thing->setStateValue(streamSDKdevBoardInputSourceStateTypeId, inputSource);
    });
}

void IntegrationPluginStreamSDK::executeAction(ThingActionInfo *info)
{
    StreamSDKDevBoard *device = dynamic_cast<StreamSDKDevBoard*>(m_devices.value(info->thing()));

    QUuid commandId;
    if (info->action().actionTypeId() == streamSDKdevBoardInputSourceActionTypeId) {
        commandId = device->setInputSource(info->action().paramValue(streamSDKdevBoardInputSourceActionInputSourceParamTypeId).toString());
        if (commandId.isNull()) {
            info->finish(Thing::ThingErrorHardwareFailure, QT_TR_NOOP("Selecting this input source is not supported. Please select another input source, start streaming from an external device or select an item in the media browser."));
            return;
        }
    }

    if (!commandId.isNull()) {
        connect(device, &StreamUnlimitedDevice::commandCompleted, info, [=](const QUuid &replyCommandId, bool success){
            if (replyCommandId == commandId) {
                info->finish(success ? Thing::ThingErrorNoError : Thing::ThingErrorHardwareFailure);
            }
        });
    } else {
        IntegrationPluginStreamUnlimited::executeAction(info);
    }
}

StreamUnlimitedDevice *IntegrationPluginStreamSDK::createStreamUnlimitedDevice()
{
    return new StreamSDKDevBoard(hardwareManager()->networkManager(), idMap, this);
}

