/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#ifndef INTEGRATIONPLUGINSENNHEISER_H
#define INTEGRATIONPLUGINSENNHEISER_H

#include "integrationpluginstreamunlimited.h"
#include <integrations/integrationplugin.h>

#include <network/zeroconf/zeroconfserviceentry.h>

#include "extern-plugininfo.h"

class ZeroConfServiceBrowser;
class StreamUnlimitedDevice;
class ArtworkColorProvider;

class IntegrationPluginSennheiser : public IntegrationPluginStreamUnlimited
{
    Q_OBJECT

    Q_PLUGIN_METADATA(IID "io.nymea.IntegrationPlugin" FILE "integrationpluginsennheiser.json")
    Q_INTERFACES(IntegrationPlugin)

public:
    explicit IntegrationPluginSennheiser();

    void init() override;

    void setupThing(ThingSetupInfo *info) override;
    void executeAction(ThingActionInfo *info) override;

protected:
    StreamUnlimitedDevice *createStreamUnlimitedDevice() override;
};

#endif // INTEGRATIONPLUGINSENNHEISER_H
