// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-mqtt.
*
* nymea-mqtt is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-mqtt is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-mqtt. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CERTIFICATELOADER_H
#define CERTIFICATELOADER_H

#include <QString>
#include <QSslKey>
#include <QSslCertificate>

class CertificateLoader
{
public:
    CertificateLoader();

    bool loadCertificate(const QString &certificateKeyFileName, const QString &certificateFileName);
    bool generateCertificate(const QString &certificateKeyFileName, const QString &certificateFileName);

    QSslKey certificateKey() const;
    QSslCertificate certificate() const;

private:
    QSslKey m_certificateKey;
    QSslCertificate m_certificate;
};

#endif // CERTIFICATELOADER_H
