// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-experience-plugin-airconditioning.
*
* nymea-experience-plugin-airconditioning is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-experience-plugin-airconditioning is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-experience-plugin-airconditioning. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "zoneinfo.h"


ZoneInfo::ZoneInfo()
{

}

ZoneInfo::ZoneInfo(const QUuid &id):
    m_id(id)
{

}

QUuid ZoneInfo::id() const
{
    return m_id;
}

QString ZoneInfo::name() const
{
    return m_name;
}

void ZoneInfo::setName(const QString &name)
{
    m_name = name;
}

double ZoneInfo::currentSetpoint() const
{
    return m_currentSetpoint;
}

void ZoneInfo::setCurrentSetpoint(double currentSetpoint)
{
    m_currentSetpoint = currentSetpoint;
}

double ZoneInfo::standbySetpoint() const
{
    return m_standbySetpoint;
}

void ZoneInfo::setStandbySetpoint(double standbySetpoint)
{
    m_standbySetpoint = standbySetpoint;
}

double ZoneInfo::setpointOverride() const
{
    return m_setpointOverride;
}

void ZoneInfo::setSetpointOverride(double setpointOverride, SetpointOverrideMode mode, const QDateTime &setpointOverrideEnd)
{
    m_setpointOverride = setpointOverride;
    m_setpointOverrideMode = mode;
    m_setpointOverrideEnd = setpointOverrideEnd;
}

ZoneInfo::SetpointOverrideMode ZoneInfo::setpointOverrideMode() const
{
    return m_setpointOverrideMode;
}

QDateTime ZoneInfo::setpointOverrideEnd() const
{
    return m_setpointOverrideEnd;
}

QList<ThingId> ZoneInfo::thermostats() const
{
    return m_thermostats;
}

void ZoneInfo::setThermostats(const QList<ThingId> &thermostats)
{
    m_thermostats = thermostats;
}

QList<ThingId> ZoneInfo::windowSensors() const
{
    return m_windowSensors;
}

void ZoneInfo::setWindowSensors(const QList<ThingId> &windowSensors)
{
    m_windowSensors = windowSensors;
}

QList<ThingId> ZoneInfo::indoorSensors() const
{
    return m_indoorSensors;
}

void ZoneInfo::setIndoorSensors(const QList<ThingId> &indoorSensors)
{
    m_indoorSensors = indoorSensors;
}

QList<ThingId> ZoneInfo::outdoorSensors() const
{
    return m_outdoorSensors;
}

void ZoneInfo::setOutdoorSensors(const QList<ThingId> &outdoorSensors)
{
    m_outdoorSensors = outdoorSensors;
}

QList<ThingId> ZoneInfo::notifications() const
{
    return m_notifications;
}

void ZoneInfo::setNotifications(const QList<ThingId> &notifications)
{
    m_notifications = notifications;
}

ZoneInfo::ZoneStatus ZoneInfo::zoneStatus() const
{
    return m_zoneStatus;
}

void ZoneInfo::setZoneStatus(ZoneStatus zoneStatus)
{
    m_zoneStatus = zoneStatus;
}

void ZoneInfo::setZoneStatusFlag(ZoneStatusFlag flag, bool set)
{
    m_zoneStatus.setFlag(flag, set);
}

double ZoneInfo::temperature() const
{
    return m_temperature;
}

void ZoneInfo::setTemperature(double temperature)
{
    m_temperature = temperature;
}

double ZoneInfo::humidity() const
{
    return m_humidity;
}

void ZoneInfo::setHumidity(double humidity)
{
    m_humidity = humidity;
}

uint ZoneInfo::voc() const
{
    return m_voc;
}

void ZoneInfo::setVoc(uint voc)
{
    m_voc = voc;
}

double ZoneInfo::pm25() const
{
    return m_pm25;
}

void ZoneInfo::setPm25(double pm25)
{
    m_pm25 = pm25;
}

TemperatureWeekSchedule ZoneInfo::weekSchedule() const
{
    return m_weekSchedule;
}

void ZoneInfo::setWeekSchedule(const TemperatureWeekSchedule &weekSchedule)
{
    m_weekSchedule = weekSchedule;
    while (m_weekSchedule.count() < 7) {
        m_weekSchedule.append(TemperatureDaySchedule());
    }
}

QVariant ZoneInfos::get(int index) const
{
    return QVariant::fromValue(at(index));
}

void ZoneInfos::put(const QVariant &variant)
{
    append(variant.value<ZoneInfo>());
}
