// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGACTION_H
#define CHARGINGACTION_H

#include <QHash>
#include <QObject>
#include <QMetaObject>

class ChargingAction
{
    Q_GADGET
    Q_PROPERTY(bool chargingEnabled READ chargingEnabled WRITE setChargingEnabled)
    Q_PROPERTY(double maxChargingCurrent READ maxChargingCurrent WRITE setMaxChargingCurrent)
    Q_PROPERTY(uint desiredPhaseCount READ desiredPhaseCount WRITE setDesiredPhaseCount)
    Q_PROPERTY(ChargingAction::ChargingActionIssuer issuer READ issuer WRITE setIssuer NOTIFY issuerChanged)

public:
    enum ChargingActionIssuer {
        ChargingActionIssuerUnknown,
        ChargingActionIssuerSurplusCharging,
        ChargingActionIssuerSpotMarketCharging,
        ChargingActionIssuerTimeRequirement,
        ChargingActionIssuerOverloadProtection
    };
    Q_ENUM(ChargingActionIssuer)

    ChargingAction();
    ChargingAction(bool chargingEnabled, double maxChargingCurrent, uint desiredPhaseCount, ChargingActionIssuer issuer, bool force = false);

    bool chargingEnabled() const;
    void setChargingEnabled(bool chargingEnabled);

    double maxChargingCurrent() const;
    void setMaxChargingCurrent(double maxChargingCurrent);

    uint desiredPhaseCount() const;
    void setDesiredPhaseCount(uint desiredPhaseCount);

    ChargingActionIssuer issuer() const;
    void setIssuer(ChargingActionIssuer issuer);
    QString issuerString() const;

    bool force() const;
    void setForce(bool force);

    static QString issuerToString(ChargingActionIssuer issuer);

private:
    bool m_chargingEnabled = 0;
    double m_maxChargingCurrent = 0;
    uint m_desiredPhaseCount = 3;
    ChargingActionIssuer m_issuer = ChargingActionIssuerUnknown;
    bool m_force = false;

};

typedef QHash<ChargingAction::ChargingActionIssuer, ChargingAction> ChargingActions;
Q_DECLARE_METATYPE(ChargingActions)

#endif // CHARGINGACTION_H
