// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef ENERGYMANAGERDBUSINTERFACE_H
#define ENERGYMANAGERDBUSINTERFACE_H

#include <QObject>
#include <QVariantList>

#include "../types/charginginfo.h"

class SmartChargingManager;

class EnergyManagerDbusInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "io.nymea.energymanager")
public:
    explicit EnergyManagerDbusInterface(SmartChargingManager *smartChargingManager, QObject *parent = nullptr);

public slots:
    Q_SCRIPTABLE QVariantList chargingInfos() const;

signals:
    Q_SCRIPTABLE void chargingInfoAdded(const QVariantMap &chargingInfo);
    Q_SCRIPTABLE void chargingInfoRemoved(const QString &evChargerId);
    Q_SCRIPTABLE void chargingInfoChanged(const QVariantMap &chargingInfo);

private:
    QVariantMap serializeChargingInfo(const ChargingInfo &info) const;

    SmartChargingManager *m_smartChargingManager = nullptr;
};

#endif // ENERGYMANAGERDBUSINTERFACE_H
