// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SIMULATIONTESTPOINT_H
#define SIMULATIONTESTPOINT_H

#include <QHash>
#include <QDebug>
#include <QVariant>
#include <QMetaObject>

class SimulationTestPoint
{
    Q_GADGET
public:
    enum TestType {
        TestTypeCharging,
        TestTypeMaxChargingCurrent,
        TestTypeStateOfCharge
    };
    Q_ENUM(TestType)

    explicit SimulationTestPoint(TestType testType, const QVariant &expectedValue);

    TestType testType() const;
    QVariant expectedValue() const;

private:
    TestType m_testType = TestTypeCharging;
    QVariant m_expectedValue;

};

typedef QList<SimulationTestPoint> SimulationTestPoints;
Q_DECLARE_METATYPE(SimulationTestPoints)

typedef QHash<uint, SimulationTestPoints> SimulationIterationTest;
Q_DECLARE_METATYPE(SimulationIterationTest)

QDebug operator<<(QDebug debug, const SimulationTestPoint &simulationTestPoint);

#endif // SIMULATIONTESTPOINT_H
