// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "timeframe.h"


TimeFrame::TimeFrame()
{

}

TimeFrame::TimeFrame(const QDateTime &startDateTime, const QDateTime &endDateTime) :
    m_startDateTime{startDateTime},
    m_endDateTime{endDateTime}
{

}

QDateTime TimeFrame::startDateTime() const
{
    return m_startDateTime;
}

void TimeFrame::setStartDateTime(const QDateTime &startDateTime)
{
    m_startDateTime = startDateTime;
}

QDateTime TimeFrame::endDateTime() const
{
    return m_endDateTime;
}

void TimeFrame::setEndDateTime(const QDateTime &endDateTime)
{
    m_endDateTime = endDateTime;
}

uint TimeFrame::durationMinutes() const
{
    return (m_endDateTime.toMSecsSinceEpoch() - m_startDateTime.toMSecsSinceEpoch()) / 60000;
}

bool TimeFrame::isValid() const
{
    return m_startDateTime.isValid() && m_endDateTime.isValid() &&
            m_startDateTime <= m_endDateTime;
}

bool TimeFrame::isActive(const QDateTime &dateTime) const
{
    return dateTime >= m_startDateTime && dateTime < m_endDateTime;
}

QDebug operator<<(QDebug debug, const TimeFrame &timeFrame)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TimeFrame(" << timeFrame.startDateTime().toString("dd.MM.yyyy hh:mm:ss");
    debug.nospace() << " - " << timeFrame.endDateTime().toString("dd.MM.yyyy hh:mm:ss") << ")";
    return debug;
}

QDebug operator<<(QDebug debug, const TimeFrames &timeFrames)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TimeFrames(" << timeFrames.count() << ")" << "\n";
    for (int i = 0; i < timeFrames.count(); i++) {
        debug.nospace() << " - " << i << " -> " << timeFrames.at(i) << "\n";
    }
    return debug;
}
