// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGSCHEDULE_H
#define CHARGINGSCHEDULE_H

#include <QDebug>
#include <QDateTime>
#include <QMetaObject>

#include "timeframe.h"
#include "chargingaction.h"

#include <typeutils.h>

class ChargingSchedule : public TimeFrame
{
    Q_GADGET
    Q_PROPERTY(QUuid evChargerId READ evChargerId WRITE setEvChargerId)
    Q_PROPERTY(QDateTime startDateTime READ startDateTime WRITE setStartDateTime)
    Q_PROPERTY(QDateTime endDateTime READ endDateTime WRITE setEndDateTime)
    Q_PROPERTY(ChargingAction action READ action WRITE setAction)

public:
    ChargingSchedule();
    ChargingSchedule(const ThingId &evChargerId);
    ChargingSchedule(const ThingId &evChargerId, const TimeFrame &timeFrame);

    ThingId evChargerId() const;
    void setEvChargerId(const ThingId &evChargerId);

    ChargingAction action() const;
    void setAction(const ChargingAction &action);

    void clear();

private:
    ThingId m_evChargerId;
    ChargingAction m_action;

};

class ChargingSchedules: public QList<ChargingSchedule>
{
    Q_GADGET
    Q_PROPERTY(int count READ count)
public:
    ChargingSchedules();
    ChargingSchedules(const QList<ChargingSchedule> &other):QList(other) { };
    ChargingSchedules(std::initializer_list<ChargingSchedule> args):QList(args) { };
    Q_INVOKABLE QVariant get(int index) const;
    Q_INVOKABLE void put(const QVariant &variant);

    ChargingSchedule getChargingSchedule(const QDateTime &dateTime = QDateTime::currentDateTime()) const;
    uint removeAllIssuer(ChargingAction::ChargingActionIssuer issuer);
    ChargingSchedules filterByIssuer(ChargingAction::ChargingActionIssuer issuer) const;

};
Q_DECLARE_METATYPE(ChargingSchedule)

QDebug operator<<(QDebug debug, const ChargingSchedule &chargingSchedule);
QDebug operator<<(QDebug debug, const ChargingSchedules &chargingSchedules);

#endif // CHARGINGSCHEDULE_H
