// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SIMULATIONBASE_H
#define SIMULATIONBASE_H

#include <QObject>

#include "../common/energytestbase.h"

#include "experience/energymanagermock.h"
#include "experience/energyexperienceenergymock.h"

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcSimulation)

namespace nymeaserver {

class MockTcpServer;

class SimulationBase : public EnergyTestBase
{
    Q_OBJECT
public:
    explicit SimulationBase(QObject *parent = nullptr);

protected slots:
    void initTestCase(const QString &loggingRules = QString());

protected:
    PluginId mockPluginId = PluginId("727a4a9a-c187-446f-aadf-f1b2220607d1");
    VendorId nymeaVendorId = VendorId("2062d64d-3232-433c-88bc-0d33c0ba2ba6");

    ExperiencePluginEnergyMock *m_experiencePlugin = nullptr;
    QString m_energyLogDbFilePath;
};

}

#endif // SIMULATIONBASE_H
