/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2024, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, GNU version 3. This project is distributed in the hope that it
* will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <QtTest>
#include <QDateTime>

#include "simulationbase.h"

using namespace nymeaserver;

class ChargerPlugEvent
{
public:
    ChargerPlugEvent() = default;
    ChargerPlugEvent(const QDateTime &dt, bool pi = false, int pu = 0)
        : dateTime{dt},
        pluggedIn{pi},
        percentageUsed{pu}
    {}
    QDateTime dateTime;
    bool pluggedIn;
    int percentageUsed = 0;
};

class Simulation: public SimulationBase
{
    Q_OBJECT
public:
    explicit Simulation(QObject *parent = nullptr) : SimulationBase(parent) { };

    typedef QList<ChargerPlugEvent> ChargerPlugEvents;
    typedef QList<int> DetailsStepList;

private slots:
    void run_data();
    void run();

    void printStates(Thing *thing);
    void updateChargerMeter(Thing *thing);

    QStringList plotOriginalData(int powerBalanceCount);
    QStringList plotSimulation(const QString &title, int powerBalanceCount);
    QStringList plotSpotMarketData(int powerBalanceCount);

};

Q_DECLARE_METATYPE(ChargerPlugEvent)
Q_DECLARE_METATYPE(Simulation::ChargerPlugEvents)
Q_DECLARE_METATYPE(Simulation::DetailsStepList)
