/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2024, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, GNU version 3. This project is distributed in the hope that it
* will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "simulationtestpoint.h"

SimulationTestPoint::SimulationTestPoint(TestType testType, const QVariant &expectedValue)
    : m_testType{testType},
    m_expectedValue{expectedValue}
{

}

SimulationTestPoint::TestType SimulationTestPoint::testType() const
{
    return m_testType;
}

QVariant SimulationTestPoint::expectedValue() const
{
    return m_expectedValue;
}

QDebug operator<<(QDebug debug, const SimulationTestPoint &simulationTestPoint)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TestPoint(";

    switch (simulationTestPoint.testType()) {
    case SimulationTestPoint::TestTypeCharging:
        debug.nospace() << "Charging";
        break;
    case SimulationTestPoint::TestTypeMaxChargingCurrent:
        debug.nospace() << "Charging current";
        break;
    case SimulationTestPoint::TestTypeStateOfCharge:
        debug.nospace() << "SoC";
        break;
    }

    debug.nospace() << ", " << simulationTestPoint.expectedValue() << ")";
    return debug;
}
