/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "timeframe.h"


TimeFrame::TimeFrame()
{

}

TimeFrame::TimeFrame(const QDateTime &startDateTime, const QDateTime &endDateTime) :
    m_startDateTime{startDateTime},
    m_endDateTime{endDateTime}
{

}

QDateTime TimeFrame::startDateTime() const
{
    return m_startDateTime;
}

void TimeFrame::setStartDateTime(const QDateTime &startDateTime)
{
    m_startDateTime = startDateTime;
}

QDateTime TimeFrame::endDateTime() const
{
    return m_endDateTime;
}

void TimeFrame::setEndDateTime(const QDateTime &endDateTime)
{
    m_endDateTime = endDateTime;
}

uint TimeFrame::durationMinutes() const
{
    return (m_endDateTime.toMSecsSinceEpoch() - m_startDateTime.toMSecsSinceEpoch()) / 60000;
}

bool TimeFrame::isValid() const
{
    return m_startDateTime.isValid() && m_endDateTime.isValid() &&
            m_startDateTime <= m_endDateTime;
}

bool TimeFrame::isActive(const QDateTime &dateTime) const
{
    return dateTime >= m_startDateTime && dateTime < m_endDateTime;
}

QDebug operator<<(QDebug debug, const TimeFrame &timeFrame)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TimeFrame(" << timeFrame.startDateTime().toString("dd.MM.yyyy hh:mm:ss");
    debug.nospace() << " - " << timeFrame.endDateTime().toString("dd.MM.yyyy hh:mm:ss") << ")";
    return debug;
}

QDebug operator<<(QDebug debug, const TimeFrames &timeFrames)
{
    const QDebugStateSaver saver(debug);
    debug.nospace() << "TimeFrames(" << timeFrames.count() << ")" << "\n";
    for (int i = 0; i < timeFrames.count(); i++) {
        debug.nospace() << " - " << i << " -> " << timeFrames.at(i) << "\n";
    }
    return debug;
}
