/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, GNU version 3. This project is distributed in the hope that it
* will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <QSignalSpy>
#include <QtTest>

#include "../common/energytestbase.h"

class TestCharging: public EnergyTestBase
{
    Q_OBJECT
public:
    explicit TestCharging(QObject *parent = nullptr);

private slots:
    // Basic adding and removing mock things
    void testAddCharger();
    void testAddSimpleCharger();
    void testAddCar();
    void testAddMeter();

    // Basic api calls
    void getSetPhaseLimits();

    void getSetLockOnUnplug_data();
    void getSetLockOnUnplug();

    void getSetAcquisitionTolerance_data();
    void getSetAcquisitionTolerance();

    void getSetBatteryLevelConsideration_data();
    void getSetBatteryLevelConsideration();

    void addChargingInfo_data();
    void addChargingInfo();

    // Test individual logic
    void testEcoMode_data();
    void testEcoMode();

    void testEcoModePhaseSwitching_data();
    void testEcoModePhaseSwitching();

    void testBatteryLevelConsideration_data();
    void testBatteryLevelConsideration();

    void batteryLevelConsiderationStopCharging_data();
    void batteryLevelConsiderationStopCharging();

    void testOverloadProtectionManualMode_data();
    void testOverloadProtectionManualMode();

    void testOverloadProtectionEcoMode_data();
    void testOverloadProtectionEcoMode();

};
