/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CHARGINGSCHEDULE_H
#define CHARGINGSCHEDULE_H

#include <QDebug>
#include <QDateTime>
#include <QMetaObject>

#include "timeframe.h"
#include "chargingaction.h"

#include <typeutils.h>

class ChargingSchedule : public TimeFrame
{
    Q_GADGET
    Q_PROPERTY(QUuid evChargerId READ evChargerId WRITE setEvChargerId)
    Q_PROPERTY(QDateTime startDateTime READ startDateTime WRITE setStartDateTime)
    Q_PROPERTY(QDateTime endDateTime READ endDateTime WRITE setEndDateTime)
    Q_PROPERTY(ChargingAction action READ action WRITE setAction)

public:
    ChargingSchedule();
    ChargingSchedule(const ThingId &evChargerId);
    ChargingSchedule(const ThingId &evChargerId, const TimeFrame &timeFrame);

    ThingId evChargerId() const;
    void setEvChargerId(const ThingId &evChargerId);

    ChargingAction action() const;
    void setAction(const ChargingAction &action);

    void clear();

private:
    ThingId m_evChargerId;
    ChargingAction m_action;

};

class ChargingSchedules: public QList<ChargingSchedule>
{
    Q_GADGET
    Q_PROPERTY(int count READ count)
public:
    ChargingSchedules();
    ChargingSchedules(const QList<ChargingSchedule> &other):QList(other) { };
    ChargingSchedules(std::initializer_list<ChargingSchedule> args):QList(args) { };
    Q_INVOKABLE QVariant get(int index) const;
    Q_INVOKABLE void put(const QVariant &variant);

    ChargingSchedule getChargingSchedule(const QDateTime &dateTime = QDateTime::currentDateTime()) const;
    uint removeAllIssuer(ChargingAction::ChargingActionIssuer issuer);
    ChargingSchedules filterByIssuer(ChargingAction::ChargingActionIssuer issuer) const;

};
Q_DECLARE_METATYPE(ChargingSchedule)

QDebug operator<<(QDebug debug, const ChargingSchedule &chargingSchedule);
QDebug operator<<(QDebug debug, const ChargingSchedules &chargingSchedules);

#endif // CHARGINGSCHEDULE_H
