/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, GNU version 3. This project is distributed in the hope that it
* will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef MOCKCONTROLLER_H
#define MOCKCONTROLLER_H

#include <typeutils.h>
#include <types/event.h>
#include <types/action.h>
#include <types/actiontype.h>

#include <QTcpServer>
#include <QDateTime>
#include <QUrlQuery>

class Thing;

class EnergyMockController : public QTcpServer
{
    Q_OBJECT
public:
    explicit EnergyMockController(Thing *thing, QObject *parent = nullptr);
    ~EnergyMockController();

    void incomingConnection(qintptr socket) override;

    void logActionExecuted(const ActionType &actionType, const Action &action);

signals:
    void generateEvent(const Event &event);
    void updateStateRequestReceived(const QUrlQuery &query);

private:
    QByteArray generateHeader();
    QByteArray generateJsonResponse(const QJsonDocument &document);
    QByteArray generateWebPage();

private slots:
    void onReadyRead();

private:
    Thing *m_thing = nullptr;
    QList<QPair<ActionTypeId, QDateTime> > m_actionList;
    QVariantList m_executedActions;
};

#endif // MOCKCONTROLLER_H
