/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU General Public License as published by the Free Software
* Foundation, GNU version 3. This project is distributed in the hope that it
* will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
* of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along with
* this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SIMULATIONBASE_H
#define SIMULATIONBASE_H

#include <QObject>

#include "../common/energytestbase.h"

#include "experience/energymanagermock.h"
#include "experience/energyexperienceenergymock.h"

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcSimulation)

namespace nymeaserver {

class MockTcpServer;

class SimulationBase : public EnergyTestBase
{
    Q_OBJECT
public:
    explicit SimulationBase(QObject *parent = nullptr);

protected slots:
    void initTestCase(const QString &loggingRules = QString());

protected:
    PluginId mockPluginId = PluginId("727a4a9a-c187-446f-aadf-f1b2220607d1");
    VendorId nymeaVendorId = VendorId("2062d64d-3232-433c-88bc-0d33c0ba2ba6");

    ExperiencePluginEnergyMock *m_experiencePlugin = nullptr;
    QString m_energyLogDbFilePath;
};

}

#endif // SIMULATIONBASE_H
