#ifndef ENERGYEXPERIENCEENERGYMOCK_H
#define ENERGYEXPERIENCEENERGYMOCK_H

#include <QObject>
#include <experiences/experienceplugin.h>

#include "energyplugin.h"

#include <QLoggingCategory>

Q_DECLARE_LOGGING_CATEGORY(dcEnergyExperience)

class EnergyManagerMock;
class SmartChargingManager;
class EnergyJsonHandler;
class NymeaEnergyJsonHandler;
class SpotMarketManager;

class ExperiencePluginEnergyMock: public ExperiencePlugin
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "io.nymea.ExperiencePlugin")
    Q_INTERFACES(ExperiencePlugin)

public:
    ExperiencePluginEnergyMock();
    void setEnergyLogDbFilePath(const QString &energyLogDbFilePath);

    void init() override;

    EnergyManagerMock *energyManager() const;
    SmartChargingManager *smartChargingManager() const;
    SpotMarketManager *spotMarketManager() const;

    void testCall();

private:
    QString m_energyLogDbFilePath;
    EnergyManagerMock *m_energyManager = nullptr;
    SmartChargingManager *m_smartChargingManager = nullptr;
    EnergyJsonHandler *m_energyJsonHandler = nullptr;
    NymeaEnergyJsonHandler *m_nymeaEnergyJsonHandler = nullptr;
    SpotMarketManager *m_spotMarketManager = nullptr;

};

#endif // ENERGYEXPERIENCEENERGYMOCK_H
