/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2022, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef SPOTMARKETDATAPROVIDERAWATTAR_H
#define SPOTMARKETDATAPROVIDERAWATTAR_H

#include <QTimer>
#include <QObject>

#include "spotmarketdataprovider.h"

class SpotMarketDataProviderAwattar : public SpotMarketDataProvider
{
    Q_OBJECT
public:
    enum AwattarCountry {
        AwattarCountryAustria,
        AwattarCountryGermany
    };
    Q_ENUM(AwattarCountry)

    explicit SpotMarketDataProviderAwattar(QNetworkAccessManager *networkManager, AwattarCountry country = AwattarCountryAustria, QObject *parent = nullptr);
    ~SpotMarketDataProviderAwattar() override = default;

    QUuid providerId() const override;

    QLocale::Country country() const;

public slots:
    void enable() override;
    void disable() override;
    void refreshData() override;

private:
    QTimer m_refreshTimer;
    QDateTime m_lastRefresh;
    QLocale::Country m_country = QLocale::Austria;

private slots:
    void onRefreshTimout();
    void evaluateAvailable();

};

#endif // SPOTMARKETDATAPROVIDERAWATTAR_H
