// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#pragma once

#include <QObject>
#include <QDBusConnection>
#include <QDBusContext>
#include <QVariantMap>
#include <QVariantList>

#include <integrations/thing.h>

class QDBusMessage;
class ChargingSessionsManager;
class FetchDataReply;
class Session;

class ChargingSessionsDBusInterface : public QObject, protected QDBusContext
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "io.nymea.energy.chargingsessions")

public:
    explicit ChargingSessionsDBusInterface(ChargingSessionsManager *manager, QObject *parent = nullptr);

public slots:
    QVariantList GetSessions(const QStringList &carThingIds, qlonglong startTimestamp = 0, qlonglong endTimestamp = 0);

private:
    void sendErrorReply(const QDBusMessage &requestMessage, const QString &message);
    void sendSessionsReply(const QDBusMessage &requestMessage, const QVariantList &sessions);
    QVariantMap serializeSession(const Session &session) const;

    ChargingSessionsManager *m_manager = nullptr;
    QDBusConnection m_connection;
};
