/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "pushbuttonagent.h"
#include "loggingcategories.h"

#include <QDBusMessage>
#include <QDBusObjectPath>

PushButtonAgent::PushButtonAgent(QObject *parent) : QObject(parent)
{

}

bool PushButtonAgent::init(QDBusConnection::BusType busType)
{
    QDBusConnection bus = busType == QDBusConnection::SessionBus ? QDBusConnection::sessionBus() : QDBusConnection::systemBus();

    bool result = bus.registerObject("/io/guh/maveod/pushbutton", this, QDBusConnection::ExportScriptableContents);
    if (!result) {
        qCWarning(dcNymeaService()) << "PushButtonAgent: Error registering PushButton agent on D-Bus.";
        return false;
    }

    QDBusMessage message = QDBusMessage::createMethodCall("io.guh.nymead", "/io/guh/nymead/UserManager", QString(), "RegisterButtonAgent");
    message << QVariant::fromValue(QDBusObjectPath("/io/guh/maveod/pushbutton"));
    QDBusMessage reply = bus.call(message);
    if (!reply.errorName().isEmpty()) {
        qCWarning(dcNymeaService()) << "PushButtonAgent: Error registering PushButton agent:" << reply.errorMessage();
        return false;
    }

    qCDebug(dcNymeaService()) << "PushButton agent registered.";
    m_initialized = true;
    return true;
}

bool PushButtonAgent::initialized() const
{
    return m_initialized;
}

void PushButtonAgent::sendButtonPressed()
{
    qCDebug(dcNymeaService()) << "PushButtonAgent: Sending button pressed event.";
    emit PushButtonPressed();
}
