/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "hardwaremanager.h"
#include "loggingcategories.h"
#include "maveod.h"

HardwareManager::HardwareManager(QObject *parent) : QObject(parent)
{

}

HardwareManager::~HardwareManager()
{
    qCDebug(dcHardwareManager()) << "Shutting down hardware manager";
    disable();
}

LedController *HardwareManager::ledController() const
{
    return m_ledController;
}

void HardwareManager::enable()
{
    qCDebug(dcHardwareManager()) << "Enable hardware components";
    if (!m_userButton) {
        m_userButton = new GpioButton(Maveod::instance()->configuration()->userGpio(), this);
        m_userButton->setName("User");
        m_userButton->setLongPressedTimeout(3000);
        m_userButton->setActiveLow(true);

        connect(m_userButton, &GpioButton::clicked, this, &HardwareManager::userButtonClicked);
        connect(m_userButton, &GpioButton::longPressed, this, &HardwareManager::userButtonLongPressed);

        if (!m_userButton->enable()) {
            qCWarning(dcHardwareManager()) << "Could not enable" << m_userButton << ". The button will not work.";
        } else {
            qCDebug(dcHardwareManager()) << m_userButton << "enabled successfully.";
        }
    }

    if (!m_resetButton) {
        m_resetButton = new GpioButton(Maveod::instance()->configuration()->resetGpio(), this);
        m_resetButton->setName("Reset");
        m_resetButton->setLongPressedTimeout(5000);
        m_resetButton->setActiveLow(true);

        connect(m_resetButton, &GpioButton::clicked, this, &HardwareManager::resetButtonClicked);
        connect(m_resetButton, &GpioButton::longPressed, this, &HardwareManager::resetButtonLongPressed);

        if (!m_resetButton->enable()) {
            qCWarning(dcHardwareManager()) << "Could not enable" << m_resetButton << ". The button will not work.";
        } else {
            qCDebug(dcHardwareManager()) << m_resetButton << "enabled successfully.";
        }
    }

    if (!m_ledController) {
        m_ledController = new LedController("/dev/i2c-1", 0x08, this);

    }
}

void HardwareManager::disable()
{
    qCDebug(dcHardwareManager()) << "Disable hardware";

    if (m_userButton) {
        delete m_userButton;
        m_userButton = nullptr;
    }

    if (m_resetButton) {
        delete m_resetButton;
        m_resetButton = nullptr;
    }

    if (m_ledController) {
        delete m_ledController;
        m_ledController = nullptr;
    }
}
