/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2021, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef FACTORYRESETHANDLER_H
#define FACTORYRESETHANDLER_H

#include <QObject>
#include <QProcess>

class SystemdService;

class FactoryResetHandler : public QObject
{
    Q_OBJECT
public:
    explicit FactoryResetHandler(SystemdService *systemdService, QObject *parent = nullptr);

    bool factoryResetRunning() const;

    void startFactoryReset();

signals:
    void factoryResetRunningChanged(bool factoryResetRunning);

private:
    SystemdService *m_systemdService = nullptr;
    bool m_factoryResetRunning = false;
    QProcess *m_factoryResetProcess = nullptr;

    bool enableRecoveryBoot();
    bool disableRecoveryBoot();

private slots:
    void onFactoryResetProcessReadyRead();
    void onFactoryResetProcessFinished(int exitCode, QProcess::ExitStatus exitStatus);

};

#endif // FACTORYRESETHANDLER_H
