# Shelly

The Shelly plugin adds support for Shelly devices (https://shelly.cloud).

The currently supported devices are:
* Shelly 1
* Shelly 1PM
* Shelly Plus 1PM
* Shelly Pro 1PM
* Shelly 1L
* Shelly 2
* Shelly 2.5
* Shelly Plus 2PM
* Shelly Plug / PlugS
* Shelly Plus Plug S
* Shelly RGBW2
* Shelly Dimmer / Dimmer 2
* Shelly Button 1
* Shelly EM
* Shelly 3EM
* Shelly Pro 3EM
* Shelly H+T
* Shelly i3
* Shelly Motion
* Shelly Vintage
* Shelly TRV
* Shelly Smoke
* Shelly Plus Smoke

## Requirements
The Shelly device needs to be connected to the same WiFi as nymea is in. New Shelly devices will open a WiFi named with
their name as SSID. For instance, a Shelly 1 would appear as "shelly1-XXXXXX". Connect to this WiFi and open the webpage that will pop up or manually open http://192.168.33.1. From there, it can be configured to connect to the same network where the nymea system is located.
No other options need to be set as they can be configured using nymea later on.


## Setting up devices
Once the Shelly is connected to the WiFi, a device discovery in nymea can be performed and will list the Shelly device.
For some Shelly devices, the connected device can be configured during setup. If the Shelly is connected to e.g. a light bulb,
choose "Light" here. Optionally, a username and password can be set. If the Shelly device is already configured to require
authentication, the username and password here must match the ones set on the Shelly. NOTE: If the Shelly is not configured
to require a login yet, but credentials are entered during setup, the Shelly device will be configured to require authentication
from now on and this login will be required also for the web interface of the Shelly device.

### Note for the Shelly Button 1
It is recommended to keep the Shelly Button 1 plugged into a power source during setup and configuration. Without a power source
it will shut down right after a button press which might interrupt the setup. However, once set up, the Shelly Button 1 will work
perfectly fine in the low power mode.

### Note for Shelly power meters
Shelly devices require an internet connection to sync the time for the total energy counters to work. The timeserver can be configured in the devices webinterface.

### Note regarding firmware updates
Some shelly devices get sold with an old firmware version installed. Some functionality will be missing. Since some point in 2021, shelly devices need to connect to the shelly cloud once to pull firmware updates. So please enable cloud access in the settings under "Internet & Security" -> "Cloud" and wait a few minutes.
If no update does show up, you can force an OTA update by calling the url in your browser generated by (http://archive.shelly-tools.de/). Open that page, provide your devices local ip, select your device and the required version. Copy the generated OTA url in your browser and press return. The new firmware version should then show up in the shelly devices webpage under "Settings" -> "Firmware update".

## Plugin properties
When adding a Shelly device that is meant to be installed in walls and has connectors to switches, a new Gateway type device
representing the Shelly device itself will be added. The gateway device allow basic monitoring (such as the connected state)
and interaction (e.g. reboot the Shelly device). In addition to that, a power switch device will appear which will reflect
presses on the Shelly's SW input. You can use generic things to connect them to those switches in order to represent your actual
devices connected to the Shelly devices.
