/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CO009_H
#define CO009_H

#include "streamunlimiteddevice.h"


class Co009 : public StreamUnlimitedDevice
{
    Q_OBJECT
public:
    explicit Co009(NetworkAccessManager *nam, const QHash<QString, QUuid> &idMap, QObject *parent = nullptr);

    QString inputSource() const;
    QUuid setInputSource(const QString &inputSource);

    bool isFavorite() const;
    QUuid setFavorite(bool favorite);

signals:
    void inputSourceChanged(const QString &inputSource);
    void favoriteChanged(bool isFavorite);

private slots:
    void onPlayerDataChanged(const QVariantMap &playerData);

private:
    QString m_inputSource;
    bool m_favorite = false;
};

#endif // CO009_H
