#ifndef STREAMSDKDEVBOARD_H
#define STREAMSDKDEVBOARD_H

#include "streamunlimiteddevice.h"

#include <QObject>

class StreamSDKDevBoard : public StreamUnlimitedDevice
{
    Q_OBJECT
public:
    explicit StreamSDKDevBoard(NetworkAccessManager *nam, const QHash<QString, QUuid> idMap, QObject *parent = nullptr);

    virtual QUuid executeContextMenu(const QString &itemId, const ActionTypeId &actionTypeId) override;

    QString inputSource() const;
    QUuid setInputSource(const QString &inputSource);

signals:
    void inputSourceChanged(const QString &inputSource);

private slots:
    void refreshInputSource();

private:
    QVariantMap composeComplexInputSourcePayload(const QString &inputSource);

private:
    QString m_inputSource;
};

#endif // STREAMSDKDEVBOARD_H
