#ifndef AMBEOSOUNDBAR_H
#define AMBEOSOUNDBAR_H

#include "streamunlimiteddevice.h"

#include <QUuid>


class AmbeoSoundBar : public StreamUnlimitedDevice
{
    Q_OBJECT
public:
    enum EqualizerPreset {
        EqualizerPresetNeutral = 0x0,
        EqualizerPresetMovie = 0x1,
        EqualizerPresetSports = 0x2,
        EqualizerPresetNews = 0x3,
        EqualizerPresetMusic = 0x4,
        EqualizerPresetDirector = 0x5
    };
    Q_ENUM(EqualizerPreset)

    enum AmbeoMode {
        AmbeoModeOff = 0x00,
        AmbeoModeLight = 0x01,
        AmbeoModeNormal = 0x02,
        AmbeoModeBoost = 0x03
    };
    Q_ENUM(AmbeoMode)

    explicit AmbeoSoundBar(NetworkAccessManager *nam, const QHash<QString, QUuid> idMap, QObject *parent = nullptr);

    bool nightMode() const;
    QUuid setNightMode(bool nightMode);

    EqualizerPreset equalizerPreset() const;
    QUuid setEqualizerPreset(EqualizerPreset equalizerPreset);

    AmbeoMode ambeoMode() const;
    QUuid setAmbeoMode(AmbeoMode ambeoMode);

    QString inputSource() const;
    QUuid setInputSource(const QString &inputSource);

    // Overriding volume calls as ambeo thing class defines it from 0 - 50 to match with the ambeo UI, but stream sdk api expects it from 0 - 100
    uint volume() const override;
    QUuid setVolume(uint volume) override;

signals:
    void inputSourceChanged(const QString &inputSource);
    void nightModeChanged(bool nightMode);
    void equalizerPresetChanged(EqualizerPreset preset);
    void ambeoModeChanged(AmbeoMode ambeoMode);

private slots:
    void refreshNightMode();
    void refreshEqualizerPreset();
    void refreshAmbeoMode();
    void refreshInputSource();

private:
    bool m_nightMode = false;
    AmbeoMode m_ambeoMode = AmbeoModeOff;
    EqualizerPreset m_equalizerPreset = EqualizerPresetNeutral;
    QString m_inputSource;
};

#endif // AMBEOSOUNDBAR_H
