/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "integrationpluginharmankardon.h"
#include "plugininfo.h"
#include "streamunlimiteddevice.h"

#include <QDebug>

QHash<QString, QUuid> idMap = {
    {"thingClassId", citationThingClassId},
    {"idParamTypeId", citationThingIdParamTypeId},

    {"connectedStateTypeId", citationConnectedStateTypeId},
    {"playbackStatusStateTypeId", citationPlaybackStatusStateTypeId},
    {"playDurationStateTypeId", citationPlayDurationStateTypeId},
    {"playTimeStateTypeId", citationPlayTimeStateTypeId},
    {"volumeStateTypeId", citationVolumeStateTypeId},
    {"muteStateTypeId", citationMuteStateTypeId},
    {"titleStateTypeId", citationTitleStateTypeId},
    {"artistStateTypeId", citationArtistStateTypeId},
    {"collectionStateTypeId", citationCollectionStateTypeId},
    {"artworkStateTypeId", citationArtworkStateTypeId},
    {"shuffleStateTypeId", citationShuffleStateTypeId},
    {"repeatStateTypeId", citationRepeatStateTypeId},
//    {"powerStateTypeId", citationPowerStateTypeId},

    {"playActionTypeId", citationPlayActionTypeId},
    {"pauseActionTypeId", citationPauseActionTypeId},
    {"stopActionTypeId", citationStopActionTypeId},
    {"skipNextActionTypeId", citationSkipNextActionTypeId},
    {"skipBackActionTypeId", citationSkipBackActionTypeId},
    {"increaseVolumeActionTypeId", citationIncreaseVolumeActionTypeId},
    {"decreaseVolumeActionTypeId", citationDecreaseVolumeActionTypeId},

    {"addToPlayQueueBrowserItemActionTypeId", citationAddToPlayQueueBrowserItemActionTypeId},
    {"clearPlaylistBrowserItemActionTypeId", citationClearPlaylistBrowserItemActionTypeId},
};


IntegrationPluginHarmanKardon::IntegrationPluginHarmanKardon(): IntegrationPluginStreamUnlimited(idMap)
{
}

void IntegrationPluginHarmanKardon::init()
{
    setupZeroConfBrowser("_sues800device._tcp", "", "HK Citation.*");
}

StreamUnlimitedDevice *IntegrationPluginHarmanKardon::createStreamUnlimitedDevice()
{
    return new StreamUnlimitedDevice(hardwareManager()->networkManager(), idMap, "/ui", this);
}


