/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#ifndef INTEGRATIONPLUGINSTREAMUNLIMITED_H
#define INTEGRATIONPLUGINSTREAMUNLIMITED_H

#include <integrations/integrationplugin.h>

#include <network/zeroconf/zeroconfserviceentry.h>

class ZeroConfServiceBrowser;
class StreamUnlimitedDevice;
class ArtworkColorProvider;

class IntegrationPluginStreamUnlimited : public IntegrationPlugin
{
    Q_OBJECT

    Q_INTERFACES(IntegrationPlugin)

public:
    explicit IntegrationPluginStreamUnlimited(QHash<QString, QUuid> ids);
    virtual ~IntegrationPluginStreamUnlimited() override = default;

    virtual void init() override;
    void startMonitoringAutoThings() override;

    void discoverThings(ThingDiscoveryInfo *info) override;
    virtual void setupThing(ThingSetupInfo *info) override;
    void executeAction(ThingActionInfo *info) override;
    void thingRemoved(Thing *thing) override;

    void browseThing(BrowseResult *result) override;
    void browserItem(BrowserItemResult *result) override;
    void executeBrowserItem(BrowserActionInfo *info) override;
    void executeBrowserItemAction(BrowserItemActionInfo *info) override;

protected:
    // To be called by subclasses in their overridden init() if needed
    void setupZeroConfBrowser(const QString &serviceType, const QString &manufacturer = QString(), const QString &model = QString(), const QString &uuidPart = QString());

    virtual StreamUnlimitedDevice* createStreamUnlimitedDevice();

private slots:
    void zeroconfServiceEntryAdded(const ZeroConfServiceEntry &entry);

private:
    void browseThingInternal(BrowseResult *result);
    void browserItemInternal(BrowserItemResult *result);

    ZeroConfServiceEntry findBestConnection(const QString &id);
    bool isLocalStreamSDK(const QHostAddress &streamSDKAddress) const;
    bool filterZeroConfEntry(const ZeroConfServiceEntry &entry);

protected:
    QHash<Thing*, StreamUnlimitedDevice*> m_devices;

private:
    ZeroConfServiceBrowser *m_zeroConfBrowser = nullptr;

    QHash<Thing*, ArtworkColorProvider*> m_artworkColorProviders;

    QString m_zeroConfModelFilter;
    QString m_zeroConfManufacturerFilter;
    QString m_zeroConfUuidPartFilter;

    QHash<QString, QUuid> m_ids;
};

#endif // INTEGRATIONPLUGINSTREAMUNLIMITED_H
