/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2024, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "chargingaction.h"

ChargingAction::ChargingAction()
{

}

ChargingAction::ChargingAction(bool chargingEnabled, double maxChargingCurrent, uint desiredPhaseCount, ChargingActionIssuer issuer, bool force) :
    m_chargingEnabled{chargingEnabled},
    m_maxChargingCurrent{maxChargingCurrent},
    m_desiredPhaseCount{desiredPhaseCount},
    m_issuer{issuer},
    m_force{force}
{

}

bool ChargingAction::chargingEnabled() const
{
    return m_chargingEnabled;
}

void ChargingAction::setChargingEnabled(bool chargingEnabled)
{
    m_chargingEnabled = chargingEnabled;
}

double ChargingAction::maxChargingCurrent() const
{
    return m_maxChargingCurrent;
}

void ChargingAction::setMaxChargingCurrent(double maxChargingCurrent)
{
    m_maxChargingCurrent = maxChargingCurrent;
}

uint ChargingAction::desiredPhaseCount() const
{
    return m_desiredPhaseCount;
}

void ChargingAction::setDesiredPhaseCount(uint desiredPhaseCount)
{
    m_desiredPhaseCount = desiredPhaseCount;
}

ChargingAction::ChargingActionIssuer ChargingAction::issuer() const
{
    return m_issuer;
}

void ChargingAction::setIssuer(ChargingActionIssuer issuer)
{
    m_issuer = issuer;
}

QString ChargingAction::issuerString() const
{
    return ChargingAction::issuerToString(m_issuer);
}

bool ChargingAction::force() const
{
    return m_force;
}

void ChargingAction::setForce(bool force)
{
    m_force = force;
}

QString ChargingAction::issuerToString(ChargingActionIssuer issuer)
{
    QString issuerString;
    switch (issuer) {
    case ChargingActionIssuerUnknown:
        issuerString = "Unknown";
        break;
    case ChargingActionIssuerSurplusCharging:
        issuerString = "Surplus";
        break;
    case ChargingActionIssuerSpotMarketCharging:
        issuerString = "Spot market";
        break;
    case ChargingActionIssuerTimeRequirement:
        issuerString = "Time requirement";
        break;
    case ChargingActionIssuerOverloadProtection:
        issuerString = "Overload protection";
        break;
    }

    return issuerString;
}
