// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "simulationbase.h"

#include <nymeacore.h>
#include <nymeasettings.h>
#include <servers/mocktcpserver.h>
#include <usermanager/usermanager.h>
#include <experiences/experiencemanager.h>

#include "../../mocks/plugins/energymocks/plugininfo.h"

Q_LOGGING_CATEGORY(dcSimulation, "Simulation")

using namespace nymeaserver;

SimulationBase::SimulationBase(QObject *parent) :
    EnergyTestBase(parent)
{
    qputenv("QTEST_FUNCTION_TIMEOUT", "3600000");

    qCDebug(dcSimulation()) << "Running in:" << QDir::currentPath();

    // Note: Energy TestBase is already loading mock plugin and energy plugin

    // Do not load any experience plugins from path...
    // we load our own for running the simulation (see initTestCase)
    qputenv("NYMEA_EXPERIENCE_PLUGINS_PATH", "");

    qCDebug(dcSimulation()).nospace() << "NYMEA_PLUGINS_EXTRA_PATH=" << qgetenv("NYMEA_PLUGINS_EXTRA_PATH");
    qCDebug(dcSimulation()).nospace() << "NYMEA_ENERGY_PLUGINS_EXTRA_PATH=" << qgetenv("NYMEA_ENERGY_PLUGINS_EXTRA_PATH");
    qCDebug(dcSimulation()).nospace() << "NYMEA_EXPERIENCE_PLUGINS_PATH=" << qgetenv("NYMEA_EXPERIENCE_PLUGINS_PATH");
}

void SimulationBase::initTestCase(const QString &loggingRules)
{
    qCDebug(dcSimulation()) << "Simulation starting...";

    // If testcase asserts cleanup won't do. Lets clear any previous test run settings leftovers
    NymeaSettings rulesSettings(NymeaSettings::SettingsRoleRules);
    rulesSettings.clear();
    NymeaSettings thingSettings(NymeaSettings::SettingsRoleThings);
    thingSettings.clear();
    NymeaSettings pluginSettings(NymeaSettings::SettingsRolePlugins);
    pluginSettings.clear();
    QDir dir(NymeaSettings::cachePath() + "/thingstates/");
    dir.removeRecursively();

    // Reset to default settings
    NymeaSettings nymeadSettings(NymeaSettings::SettingsRoleGlobal);
    nymeadSettings.clear();

    if (loggingRules.isEmpty()) {
        EnergyTestBase::initTestCase("*.debug=false\nApplication.debug=true\nSimulation.debug=true\nExperiences.debug=true\nNymeaEnergy.debug=true\nEnergyMocks.debug=true\nDBus.warning=false", false, true);
    } else {
        EnergyTestBase::initTestCase(loggingRules, false, true);
    }

    // Load our mocked energy plugin using the given database
    if (!m_energyLogDbFilePath.isEmpty()) {
        m_experiencePlugin = new ExperiencePluginEnergyMock();
        m_experiencePlugin->setEnergyLogDbFilePath(m_energyLogDbFilePath);
        NymeaCore::instance()->experienceManager()->loadExperiencePlugin(m_experiencePlugin);
    }

    removeDevices();
}
