#!/bin/bash

SCRIPT_DIR=$(dirname $0)
BUILD_DIR="$SCRIPT_DIR/../build-nymea-energy-plugin-nymea-Desktop-Debug/"

#------------------------------------------------------------------------------------------
function usage() {
  cat <<EOF

Build the coverage report.

OPTIONS:
  -b --build-dir [DIRNAME]            The path to the build directory containing the gcov files.
                                      Default: $BUILD_DIR
  -h, --help                          Show this message

EOF
}

#------------------------------------------------------------------------------------------

while [ "$1" != "" ]; do
    case $1 in
        -b | --build-dir )
            BUILD_DIR=$2
            shift;;
        -h | --help )
            usage && exit 0;;
        * )
            usage && exit 1;;
    esac
    shift
done


COV_DIR="${BUILD_DIR}/coverage"
HTML_RESULTS="${COV_DIR}/html"

# Build code coverage html report
mkdir -p ${HTML_RESULTS}
lcov -d "${BUILD_DIR}" -c -o "${COV_DIR}/coverage.info"
lcov -r "${COV_DIR}/coverage.info" "*.h" "*/tests/*" "*.moc" "*moc_*.cpp" "*/test/*" "/usr/include/*" "*/build*/*" -o "${COV_DIR}/coverage-filtered.info"
genhtml -o "${HTML_RESULTS}" "${COV_DIR}/coverage-filtered.info"
lcov -d "${COV_DIR}" -z

# Open the index.html in the browser
open "${HTML_RESULTS}/index.html" 2>&1 1>/dev/null
