// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-nymea.
*
* nymea-energy-plugin-nymea.s free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-nymea.s distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-nymea. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef EVCHARGER_H
#define EVCHARGER_H

#include "integrations/thing.h"
#include "smartchargingmanager.h"

#include <hardware/electricity.h>

#include <QObject>

class ThingManager;
class ThingActionInfo;

class EvCharger : public QObject
{
    Q_OBJECT
public:
    explicit EvCharger(ThingManager *thingManager, Thing *parent = nullptr);

    ThingId id() const;
    Thing *thing() const;
    QString name() const;

    uint chargingEnabledLockDuration() const; // s
    void setChargingEnabledLockDuration(uint chargingEnabledLockDuration);
    bool chargingEnabledLocked(const QDateTime &currentDateTime) const;

    uint chargingCurrentLockDuration() const; // s
    void setChargingCurrentLockDuration(uint chargingCurrentLockDuration);
    bool chargingCurrentLocked(const QDateTime &currentDateTime) const;

    bool available() const;

    bool chargingEnabled() const;
    ThingActionInfo *setChargingEnabled(bool power, const QDateTime &currentDateTime, bool force = false);

    bool pluggedIn() const;
    bool charging() const;

    uint maxChargingCurrentMaxValue() const;
    uint maxChargingCurrentMinValue() const;
    uint maxChargingCurrent() const;
    ThingActionInfo *setMaxChargingCurrent(uint maxChargingCurrent, const QDateTime &currentDateTime, bool force = false);

    bool hasPowerMeter() const;
    double currentPower() const;

    uint phaseCount() const;
    Electricity::Phases phases() const;
    Electricity::Phases meteredPhases() const;

    bool canSetPhaseCount() const;
    ThingActionInfo *setDesiredPhaseCount(int desiredPhases);

private:
    ThingManager *m_thingManager = nullptr;
    Thing *m_thing = nullptr;

    uint m_chargingEnabledLockDuration = 300;
    uint m_chargingCurrentLockDuration = 10;

    QDateTime m_lastChargingEnabledAction;
    QDateTime m_lastChargingCurrentAction;
};

class EvChargers: public QList<EvCharger*>
{

};

#endif // EVCHARGER_H
