#ifndef SPOTMARKETPROVIDERMOCK_H
#define SPOTMARKETPROVIDERMOCK_H

#include <QObject>

#include "../../../energyplugin/spotmarket/spotmarketdataprovider.h"

class SpotMarketDataProviderMock : public SpotMarketDataProvider
{
    Q_OBJECT
public:
    explicit SpotMarketDataProviderMock(QNetworkAccessManager *networkManager, QObject *parent = nullptr);
    ~SpotMarketDataProviderMock() override = default;

    QUuid providerId() const override;

    void setDataEntries(const ScoreEntries &scoreEntries);

    QDateTime currentDateTime() const;
    void setCurrentDataTime(const QDateTime &currentDateTime);

    bool prepareResourceData(const QString &resourceName, const QDateTime &startDateTime);
    void setAvailable(bool available);

public slots:
    void enable() override;
    void disable() override;
    void refreshData() override;

private:
    ScoreEntries m_preparedScoreEntries;
    QDateTime m_currentDateTime;
};

#endif // SPOTMARKETPROVIDERMOCK_H
