
# nymea energy manager

Repository for the energy plugin for the energy experience.

This energy plugin adds smart charging, spotmarket charging and overload protection to the nymea energy experience.

## Energy manager configuration

In order to tweak local energy manager setups a read only configuration file has been introduced. The file can be specified using the environment variable
`NYMEA_ENERGY_MANAGER_CONFIG`. If the environment path has not been specified, by default the energy manager will try to load the file from `/var/lib/nymea/energy-manager-configuration.json`.

If there is no such file, the defaults will be used, which is **recommended**.

> Note: this configuration is desinged to test certain behaviors in certain test environments, it is not designed to be used by default or changed by the user.

The default configuration looks like this:

```json
{
    "chargingEnabledLockDuration": 300,
    "chargingCurrentLockDuration": 5,
    "minimumScheduleDuration": 15,
    "spotMarketChargePredictableEnergyPercentage": 0.5
}
```

* `chargingEnabledLockDuration`: defines in seconds how long a charger is locked when charging has been paused or resumed. Default is 5 minutes, which ensures a certain continuity for the car. Thsi prevents a constant charging start and stop.
* `chargingCurrentLockDuration`: defines in seconds how long a charger is locked when the charging current has been changed. According to the spec this can be changed every 10 seconds. For tests we can go under this spec limit.
* `minimumScheduleDuration`: duration in minutes. When spotmarket charging scheduled get calculated, there might be a situation where charging wpuld stop for an hour and the rest would be only one minute. In order to prevent such small schedules, this limit will be considered from the scheduler, the minimum is 15 minutes, everything underneeth will be appende or prepended to existing charging slots.
* `spotMarketChargePredictableEnergyPercentage`: if the spotmarket data are not availabe yet for the next day, this paramter specifies how much will be planed with the already known schedule. The rest will be planed once the schedules are available.


## Simulations

In order to verify how the bussineslogic works and the target can be reached, a simulation environment has been set up producing plots of the simulation.

For simplification and beeing able to play with the simulations, a docker tool can be used to run the simulations in a container.

> Note: please install docker before running the script

    ./docker-simulation.sh


Once the simulation have finished successfully the plots can be found in the `results/` folder of the source directory.

## Test coverage report

In order to build a test coverage report from the energy manager, the source code bust be built with the coverage support enabled.

Add the `qmake` configuration in order to enable it:

    qmake CONFIG+=coverage
on
    make -j$(nproc)


    # The tests can be found in tests/auto
    nymeaenrgytestcharging
    nymeaenrgytestspotmarket

    # Optionally you can also run the simulations to show coverage of the simulation code
    nymea-energy-simulation

Once all tests have run successfully, the report can be generated as follows:

    ./build-coverage-report.sh -b builddir

The tool opens the generated report in the browser.
