/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2023, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef NYMEAENERGYJSONHANDLER_H
#define NYMEAENERGYJSONHANDLER_H

#include <QObject>

#include <jsonrpc/jsonhandler.h>

#include "types/scoreentry.h"

class SmartChargingManager;
class SpotMarketManager;

class NymeaEnergyJsonHandler : public JsonHandler
{
    Q_OBJECT
public:
    explicit NymeaEnergyJsonHandler(SpotMarketManager *spotMarketManager, SmartChargingManager *smartChargingManager, QObject *parent = nullptr);

    QString name() const override;

    Q_INVOKABLE JsonReply *GetPhasePowerLimit(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetPhasePowerLimit(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetAcquisitionTolerance(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetAcquisitionTolerance(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetBatteryLevelConsideration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetBatteryLevelConsideration(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetChargingInfos(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetChargingInfo(const QVariantMap &params, const JsonContext &context);

    Q_INVOKABLE JsonReply *GetLockOnUnplug(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetLockOnUnplug(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetAvailableSpotMarketProviders(const QVariantMap &params);
    Q_INVOKABLE JsonReply *GetSpotMarketConfiguration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *SetSpotMarketConfiguration(const QVariantMap &params);
    Q_INVOKABLE JsonReply *GetSpotMarketScoreEntries(const QVariantMap &params);

    Q_INVOKABLE JsonReply *GetChargingSchedules(const QVariantMap &params);

signals:
    void PhasePowerLimitChanged(const QVariantMap &params);
    void AcquisitionToleranceChanged(const QVariantMap &params);
    void LockOnUnplugChanged(const QVariantMap &params);
    void ChargingInfoAdded(const QVariantMap &params);
    void ChargingInfoRemoved(const QVariantMap &params);
    void ChargingInfoChanged(const QVariantMap &params);
    void SpotMarketConfigurationChanged(const QVariantMap &params);
    void SpotMarketScoreEntriesChanged(const QVariantMap &params);
    void ChargingSchedulesChanged(const QVariantMap &params);
    void BatteryLevelConsiderationChanged(const QVariantMap &params);

private:
    SpotMarketManager *m_spotMarketManager;
    SmartChargingManager *m_smartChargingManager = nullptr;

    void sendSpotMarketConfigurationChangedNotification();

};

#endif // NYMEAENERGYJSONHANDLER_H
