/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2025, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of nymea.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* GNU Lesser General Public License Usage
* Alternatively, this project may be redistributed and/or modified under the
* terms of the GNU Lesser General Public License as published by the Free
* Software Foundation; version 3. This project is distributed in the hope that
* it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this project. If not, see <https://www.gnu.org/licenses/>.
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "energysettings.h"
#include <nymeasettings.h>

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcChargingSessions)

EnergySettings::EnergySettings(QObject *parent)
    : QSettings(NymeaSettings::settingsPath() + "/energy.conf", QSettings::IniFormat, parent)
{

}

ThingId EnergySettings::getAssociatedCarId(const ThingId &evChargerId)
{
    // FIXME: this is not a very elegant way to get the information about the associated car thing id.
    // A better solution would be a direct API between this energy plugin and the nymea-energy-plugin-nymea,
    // but for now this should do the job. The entire implementation works also without the energy plugin,
    // therefore this is optional either way.

    ThingId associatedCarId;

    QString groupName = "ChargingConfigurations";
    if (!childGroups().contains(groupName)) {
        // Legacy, if no charging configurations, try loading the ChargingInfos
        groupName = "ChargingInfos";
    }

    beginGroup(groupName);
    foreach (const QString &evChargerIdString, childGroups()) {
        ThingId id = ThingId::fromString(evChargerIdString);
        if (id == evChargerId) {
            beginGroup(evChargerIdString);
            associatedCarId = ThingId(value("assignedCarId").toUuid());
            endGroup(); // evChargerIdString
            break;
        }
    }
    endGroup(); // groupname

    return associatedCarId;
}
