// SPDX-License-Identifier: GPL-3.0-or-later

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright (C) 2013 - 2024, nymea GmbH
* Copyright (C) 2024 - 2025, chargebyte austria GmbH
*
* This file is part of nymea-energy-plugin-chargingsessions.
*
* nymea-energy-plugin-chargingsessions is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* nymea-energy-plugin-chargingsessions is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with nymea-energy-plugin-chargingsessions. If not, see <https://www.gnu.org/licenses/>.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "processreply.h"

#include <QLoggingCategory>
Q_DECLARE_LOGGING_CATEGORY(dcChargingSessions)

ProcessReply::ProcessReply(QObject *parent)
    : QObject{parent}
{

}

void ProcessReply::finishReply()
{
    m_isFinished = true;
    emit finished();
    deleteLater();
}

void ProcessReply::finishReply(ChargingSessionsManager::ChargingSessionsError error)
{
    m_error = error;
    finishReply();
}

ChargingSessionsManager::ChargingSessionsError ProcessReply::error() const
{
    return m_error;
}

bool ProcessReply::isFinished() const
{
    return m_isFinished;
}
