QT -= gui

TARGET = $$qtLibraryTarget(nymea_apikeysproviderplugincommunity)
TEMPLATE = lib

CONFIG += c++11

CONFIG += plugin c++11 link_pkgconfig
PKGCONFIG += nymea

exists(data/apikeys.json) {
    message("Using API keys file from data/apikeys.file")
    JSONFILE = data/apikeys.json
} else:exists(/opt/nymea-apikeys-community/apikeys.json) {
    message("Using API keys file from /opt/nymea-apikeys-community/apikeys.json")
    JSONFILE = /opt/nymea-apikeys-community/apikeys.json
} else {
    error("No API keys file found. Cannot build.\nPlease either provide an api keys file in data/apikeys.json\nor in /opt/nymea-apikeys-community/apikeys.json")
}

# Convert the json file into a includeable header
includegenerator.input = JSONFILE
includegenerator.output  = apikeys.h
includegenerator.commands = base64 -w 0 ${QMAKE_FILE_NAME} > ${QMAKE_FILE_OUT};
includegenerator.commands += sed -i \'s/^/const QByteArray data = \"/\' ${QMAKE_FILE_OUT};
includegenerator.commands += sed -i \'s/\$\$/\";/\' ${QMAKE_FILE_OUT}
includegenerator.dependency_type = TYPE_C
includegenerator.CONFIG += no_link combine
QMAKE_EXTRA_COMPILERS += includegenerator


SOURCES += \
    apikeysproviderstatic.cpp

HEADERS += \
    apikeysproviderstatic.h \
    apikeys.h # generated by extra compiler


target.path = $$[QT_INSTALL_LIBS]/nymea/apikeysproviders/
INSTALLS += target
