# maveod

The platform management daemon for the maveo box.

## Bluetooth server
The Bluetooth server for the wireless network will be used from the libnymea-networkmanager and is documented [here](https://github.com/nymea/nymea-networkmanager#bluetooth-gatt-profile).


## Debug server

The debug server is listening on the unix socket `/run/maveod`. This debug server can be used to simulate 
any maveo button event in the system in order to give the possibility to test and interact with the system
without physical access. The server requires root ssh login in order to use it.


*Request format*:

    {
        "button": "user | reset",
        "action": "click | longpress"
    }

*Response format*:

    {
        "message": "Status message",
        "success": bool
    }

The server will close the connection after each request.

### Click the user button

In order to click the user button from the debug server, following command can be used:

    $ echo '{ "button": "user", "action": "click" }' | nc -U /run/maveod

    {
        "message": "User button clicked.",
        "success": true
    }

### Long press the user button

In order to long press the user button from the debug server, following command can be used:

    $ echo '{ "button": "user", "action": "longpress" }' | nc -U /run/maveod

    {
        "message": "User button long pressed.",
        "success": true
    }
 
### Click the reset button

In order to click the reset button from the debug server, following command can be used:

    $ echo '{ "button": "reset", "action": "click" }' | nc -U /run/maveod

    {
        "message": "Reset button clicked.",
        "success": true
    }
 
### Long press the reset button

In order to long press the reset button from the debug server, following command can be used:

    $ echo '{ "button": "reset", "action": "longpress" }' | nc -U /run/maveod

    {
        "message": "Reset button long pressed.",
        "success": true
    }
 


