/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <QObject>
#include <QSettings>

class Configuration : public QObject
{
    Q_OBJECT
public:
    explicit Configuration(QObject *parent = nullptr);

    // Bluetooth configurations
    QString advertiseName() const;
    QString hardwareVersion() const;
    QString modelName() const;
    int advertisingTimeout() const;

    // Hardware configurations
    int userGpio() const;
    int resetGpio() const;

private:
    QString m_configurationFileName = "/etc/maveod/maveod.conf";
    QString m_advertiseName = "maveo-box";
    QString m_hardwareVersion = "2.0.0";
    QString m_modelName = "maveo";
    int m_advertisingTimeout = 60000;

    int m_userGpio = 128;
    int m_resetGpio = 129;

public slots:
    void loadConfiguration(const QString &configurationFileName);


};

#endif // CONFIGURATION_H
