/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Copyright 2013 - 2020, nymea GmbH
* Contact: contact@nymea.io
*
* This file is part of maveod.
* This project including source code and documentation is protected by
* copyright law, and remains the property of nymea GmbH. All rights, including
* reproduction, publication, editing and translation, are reserved. The use of
* this project is subject to the terms of a license agreement to be concluded
* with nymea GmbH in accordance with the terms of use of nymea GmbH, available
* under https://nymea.io/license
*
* For any further details and any questions please contact us under
* contact@nymea.io or see our FAQ/Licensing Information on
* https://nymea.io/license/faq
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "configuration.h"

Configuration::Configuration(QObject *parent) :
    QObject(parent)
{

}

QString Configuration::advertiseName() const
{
    return m_advertiseName;
}

QString Configuration::hardwareVersion() const
{
    return m_hardwareVersion;
}

QString Configuration::modelName() const
{
    return m_modelName;
}

int Configuration::advertisingTimeout() const
{
    return m_advertisingTimeout;
}

int Configuration::userGpio() const
{
    return m_userGpio;
}

int Configuration::resetGpio() const
{
    return m_resetGpio;
}

void Configuration::loadConfiguration(const QString &configurationFileName)
{
    QSettings settings(configurationFileName, QSettings::IniFormat);
    settings.beginGroup("Bluetooth");
    m_advertiseName = settings.value("advertiseName", "maveo-box").toString();
    m_modelName = settings.value("modelName", "maveo").toString();
    m_hardwareVersion = settings.value("hardwareVersion", "2.0.0").toString();
    m_advertisingTimeout = settings.value("advertisingTimeout", 60000).toInt();
    settings.endGroup();

    settings.beginGroup("Hardware");
    m_userGpio = settings.value("userGpio", 5).toInt();
    m_resetGpio = settings.value("resetGpio", 8).toInt();
    settings.endGroup();
}
